using Godot;
using Godot.Collections;
public partial class Leaderboard : Control
{
    [Export] ScrollContainer _scrollContainer;

    [Export] PackedScene userPanel;

    [Export] MarginContainer marginContainer;

    [Export] TextEdit nameText;
    [Export] TextEdit pointsText;

    [Export] string googleFormsID;
    [Export] string googleSheetsID;
    
    string formsUrl = "https://docs.google.com/forms/u/0/d/e";
    string sheetsUrl = "https://opensheet.elk.sh";

    private string urlSubmit;
    private string urlData;
    string[] headers = {
        "User-Agent: Demonic-Leaderboard/0.0.1",
        "Content-Type: application/x-www-form-urlencoded"
    };

    HttpClient client = new HttpClient();

  public override void _Ready()
  {
      urlSubmit = $"{formsUrl}/{googleFormsID}/formResponse";
      urlData = $"{sheetsUrl}/{googleSheetsID}/Data";
  }

  void Update()
  {
      var http = new HttpRequest();
      AddChild(http);
      http.RequestCompleted += (long result, long responseCode, string[] headers, byte[] body) =>
      {
          HttpDone(http, result, responseCode, headers, body);
      };
      
      var err = http.Request(urlData, headers, HttpClient.Method.Get);
      if (err != 0)
      {
          http.QueueFree();
      }
  }

  void Add()
  {
      var http = new HttpRequest();
      AddChild(http);
      http.RequestCompleted += (long result, long responseCode, string[] headers, byte[] body) =>
      {
          HttpSubmit(http, result, responseCode, headers, body);
      };
      var userData = new Dictionary()
      {
          { "entry.1772479419", nameText.Text },
          { "entry.680244927", pointsText.Text }
      };
      var data = client.QueryStringFromDict(userData);
      var err = http.Request(urlSubmit, headers, HttpClient.Method.Post, data);
      if (err != 0)
      {
          http.QueueFree();
      }
      else
      {
          nameText.Text = "";
          pointsText.Text = "";
      }
  }

  void HttpSubmit(HttpRequest http, long result, long respCode, string[] headers, byte[] body)
  {
      http.QueueFree(); 
  }
  
  void HttpDone(HttpRequest http, long result, long respCode, string[] headers, byte[] body)
  {
      http.QueueFree();
      if (result != null)
      {
          var data = Json.ParseString(body.GetStringFromUtf8());
          Array array = data.AsGodotArray();
          foreach (Dictionary entry in array)
          {
              string name = (string)entry["Name"];
              string points = (string)entry["Points"];
              
              GD.Print($"Name: {name}, Points: {points}");

              var users = userPanel.Instantiate();
              var userName = users.GetNode<RichTextLabel>("Name");
              var userPoints = users.GetNode<RichTextLabel>("Points");
              userName.Text = name;
              userPoints.Text = points;
              marginContainer.AddChild(users);
          }
      }
  }
}
